/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.minecraft.class_1161;
import net.minecraft.class_124;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2399;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3079;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3614;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7066;
import org.jetbrains.annotations.NotNull;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.MHelper;
import paulevs.betternether.mixin.common.BlockBehaviourAccessor;
import paulevs.betternether.mixin.common.BlockBehaviourPropertiesAccessor;
import paulevs.betternether.registry.NetherBiomes;
import paulevs.betternether.registry.NetherBlocks;
import paulevs.betternether.world.NetherBiome;
import paulevs.betternether.world.features.NetherChunkPopulatorFeature;
import paulevs.betternether.world.structures.StructureType;
import paulevs.betternether.world.structures.StructureWorld;
import ru.bclib.BCLib;
import ru.bclib.world.biomes.BCLBiome;

public class CommandRegistry {
    private static final DynamicCommandExceptionType ERROR_BIOME_NOT_FOUND = new DynamicCommandExceptionType(object -> new class_2585("The next biome (" + object + ") was not found."));
    private static final DynamicCommandExceptionType ERROR_NBT_STRUCTURE_NOT_FOUND = new DynamicCommandExceptionType(object -> new class_2585("The nbt-structure (" + object + ") was not found."));
    private static final int MAX_SEARCH_RADIUS = 12800;
    private static final int SEARCH_STEP = 8;
    private static int biomeIndex = 0;
    private static Map<class_6880<class_1959>, class_2680> biomeMap = new HashMap<class_6880<class_1959>, class_2680>();
    private static int biomeMapIdx = 0;
    private static class_2680[] states = new class_2680[]{class_2246.field_10272.method_9564(), class_2246.field_10060.method_9564(), class_2246.field_10049.method_9564(), class_2246.field_10157.method_9564(), class_2246.field_10317.method_9564(), class_2246.field_10357.method_9564(), class_2246.field_10087.method_9564(), class_2246.field_9997.method_9564(), class_2246.field_10227.method_9564()};

    public static void register() {
        CommandRegistrationCallback.EVENT.register(CommandRegistry::register);
    }

    private static void register(CommandDispatcher<class_2168> dispatcher, boolean dedicated) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"bn").requires(source -> source.method_9259(4))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"request_garbage_collection").requires(source -> source.method_9259(4))).executes(ctx -> CommandRegistry.requestGC((CommandContext<class_2168>)ctx)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"tpnext").requires(source -> source.method_9259(4))).executes(ctx -> CommandRegistry.teleportToNextBiome((CommandContext<class_2168>)ctx)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"place_all").requires(source -> source.method_9259(4))).executes(ctx -> CommandRegistry.placeAllBlocks((CommandContext<class_2168>)ctx)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"place_matching").requires(source -> source.method_9259(4))).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandRegistry.placeMatchingBlocks((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"type")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"debug_ore").requires(source -> source.method_9259(4))).executes(ctx -> CommandRegistry.revealOre((CommandContext<class_2168>)ctx)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"place_nbt").requires(source -> source.method_9259(4))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandRegistry.placeNbt((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"sliceZ").requires(source -> source.method_9259(4))).executes(ctx -> CommandRegistry.slice((CommandContext<class_2168>)ctx, true)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"sliceX").requires(source -> source.method_9259(4))).executes(ctx -> CommandRegistry.slice((CommandContext<class_2168>)ctx, false))));
    }

    private static int requestGC(CommandContext<class_2168> ctx) {
        System.gc();
        return 1;
    }

    private static int teleportToNextBiome(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2338 target;
        class_2680 state;
        class_2168 source = (class_2168)ctx.getSource();
        List<NetherBiome> biomes = NetherBiomes.ALL_BN_BIOMES;
        if (biomeIndex < 0 || biomeIndex >= biomes.size()) {
            source.method_9213((class_2561)new class_2585("Failed to find the next Biome...").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
            return 0;
        }
        final BCLBiome biome = biomes.get(biomeIndex);
        source.method_9226((class_2561)new class_2585("Locating Biome " + biome).method_10862(class_2583.field_24360.method_10977(class_124.field_1077)), false);
        biomeIndex = (biomeIndex + 1) % biomes.size();
        class_2338 currentPosition = new class_2338(source.method_9222());
        class_2338 biomePosition = (class_2338)source.method_9225().method_24500(b -> b.equals(biome.getActualBiome()), currentPosition, 12800, 8).getFirst();
        final String biomeName = biome.toString();
        if (biomePosition == null) {
            throw ERROR_BIOME_NOT_FOUND.create((Object)biomeName);
        }
        class_3222 player = source.method_9207();
        double yPos = source.method_9222().method_10214();
        boolean didWrap = false;
        do {
            target = new class_2338((double)biomePosition.method_10263(), yPos, (double)biomePosition.method_10260());
            state = player.field_6002.method_8320(target);
            if (!((yPos -= 1.0) <= (double)(player.field_6002.method_31607() + 1))) continue;
            if (didWrap) break;
            yPos = 127.0;
            didWrap = true;
        } while (!state.method_26215() && yPos > (double)player.field_6002.method_31607() && yPos < (double)player.field_6002.method_31600());
        class_1161 targetPlayerPos = new class_1161((double)target.method_10263() + 0.5, (double)(target.method_10264() - 1), (double)target.method_10260() + 0.5);
        player.field_13987.method_14360(targetPlayerPos.field_5661, targetPlayerPos.field_5660, targetPlayerPos.field_5659, 0.0f, 0.0f, Collections.EMPTY_SET);
        class_7066.class_7068 result = new class_7066.class_7068(){

            public Either<class_5321, class_6862> method_41173() {
                return Either.left((Object)((class_5321)biome.getActualBiome().method_40230().orElseThrow()));
            }

            public Optional<class_7066.class_7068> method_41175(class_5321 resourceKey) {
                return Optional.empty();
            }

            public String method_41176() {
                return biomeName;
            }

            public boolean test(Object o) {
                return false;
            }
        };
        return class_3079.method_24499((class_2168)source, (class_7066.class_7068)result, (class_2338)currentPosition, (Pair)new Pair((Object)biomePosition, (Object)biome.getActualBiome()), (String)"commands.locatebiome.success");
    }

    private static int placeMatchingBlocks(CommandContext<class_2168> ctx, String type) throws CommandSyntaxException {
        class_2168 source = (class_2168)ctx.getSource();
        class_3222 player = source.method_9207();
        class_243 pos = source.method_9222();
        LinkedList<class_2248> blocks = new LinkedList<class_2248>();
        for (class_2248 block : NetherBlocks.getModBlocks().stream().sorted(CommandRegistry::compareBlockNames).collect(Collectors.toList())) {
            String name = class_2378.field_11146.method_10221((Object)block).method_12832();
            if (name.indexOf(type) < 0) continue;
            blocks.add(block);
        }
        CommandRegistry.placeBlockRow(player, pos, blocks, 1, true);
        return 1;
    }

    @NotNull
    private static int compareBlockNames(class_2248 a, class_2248 b) {
        String as = class_2378.field_11146.method_10221((Object)a).method_12832();
        String bs = class_2378.field_11146.method_10221((Object)b).method_12832();
        return as.compareTo(bs);
    }

    private static int placeNbt(CommandContext<class_2168> ctx, String type) throws CommandSyntaxException {
        class_2168 source = (class_2168)ctx.getSource();
        class_3222 player = source.method_9207();
        class_243 pos = source.method_9222();
        class_3218 level = source.method_9225();
        try {
            StructureWorld structure = new StructureWorld(type, 0, StructureType.FLOOR);
            if (structure == null) {
                throw ERROR_NBT_STRUCTURE_NOT_FOUND.create((Object)type);
            }
            structure.generate((class_5425)level, new class_2338(pos), MHelper.RANDOM, 128, NetherChunkPopulatorFeature.generatorForThread().context);
        }
        catch (Throwable t) {
            BCLib.LOGGER.error("Error loading from nbt: " + type);
            BCLib.LOGGER.error(t.toString());
            throw ERROR_NBT_STRUCTURE_NOT_FOUND.create((Object)type);
        }
        return 1;
    }

    private static int revealOre(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 source = (class_2168)ctx.getSource();
        class_3218 level = source.method_9225();
        class_243 pos = source.method_9222();
        class_2338.class_2339 bp = new class_2338.class_2339();
        class_2680 AIR = class_2246.field_10124.method_9564();
        for (int y = 1; y < level.method_31605(); ++y) {
            bp.method_33098(y);
            for (int x = -64; x < 64; ++x) {
                bp.method_33097((int)pos.field_1352 + x);
                for (int z = -64; z < 64; ++z) {
                    class_2680 fillState;
                    bp.method_33099((int)pos.field_1350 + z);
                    if (y == 1) {
                        class_6880 b = level.method_23753((class_2338)bp);
                        fillState = biomeMap.computeIfAbsent((class_6880<class_1959>)b, bb -> {
                            biomeMapIdx = (biomeMapIdx + 1) % states.length;
                            return states[biomeMapIdx];
                        });
                    } else {
                        fillState = AIR;
                    }
                    class_2680 state = level.method_8320((class_2338)bp);
                    if (y != 1 && state.method_27852(class_2246.field_10124) || state.method_27852(NetherBlocks.CINCINNASITE_ORE) || state.method_27852(NetherBlocks.NETHER_RUBY_ORE) || state.method_27852(NetherBlocks.NETHER_LAPIS_ORE) || state.method_27852(NetherBlocks.NETHER_REDSTONE_ORE) || state.method_27852(class_2246.field_10213) || state.method_27852(class_2246.field_23077) || state.method_27852(class_2246.field_22109)) continue;
                    BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)bp, fillState);
                }
            }
        }
        return 1;
    }

    private static int slice(CommandContext<class_2168> ctx, boolean constX) throws CommandSyntaxException {
        class_2168 source = (class_2168)ctx.getSource();
        class_3218 level = source.method_9225();
        class_243 pos = source.method_9222();
        class_2680 AIR = class_2246.field_10124.method_9564();
        class_2338.class_2339 bp = new class_2338.class_2339();
        for (int y = 1; y < level.method_31605(); ++y) {
            int x;
            bp.method_33098(y);
            int n = x = constX ? 0 : -64;
            while (x < 64) {
                int z;
                bp.method_33097((int)pos.field_1352 + x);
                int n2 = z = constX ? -64 : 0;
                while (z < 64) {
                    class_2680 fillState;
                    bp.method_33099((int)pos.field_1350 + z);
                    if (y == 1) {
                        class_6880 b = level.method_23753((class_2338)bp);
                        fillState = biomeMap.computeIfAbsent((class_6880<class_1959>)b, bb -> {
                            biomeMapIdx = (biomeMapIdx + 1) % states.length;
                            return states[biomeMapIdx];
                        });
                    } else {
                        fillState = AIR;
                    }
                    BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)bp, fillState);
                    ++z;
                }
                ++x;
            }
        }
        return 1;
    }

    private static int placeAllBlocks(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 source = (class_2168)ctx.getSource();
        class_3222 player = source.method_9207();
        class_243 pos = source.method_9222();
        LinkedList<class_2248> pickaxes = new LinkedList<class_2248>();
        LinkedList<class_2248> axes = new LinkedList<class_2248>();
        LinkedList<class_2248> hoes = new LinkedList<class_2248>();
        LinkedList<class_2248> shovels = new LinkedList<class_2248>();
        LinkedList<class_2248> other = new LinkedList<class_2248>();
        for (class_2248 block : NetherBlocks.getModBlocks().stream().sorted(CommandRegistry::compareBlockNames).collect(Collectors.toList())) {
            class_4970.class_2251 properties = ((BlockBehaviourAccessor)block).getProperties();
            class_3614 material = ((BlockBehaviourPropertiesAccessor)properties).getMaterial();
            if (material.equals(class_3614.field_15914) || material.equals(class_3614.field_15953)) {
                pickaxes.add(block);
                continue;
            }
            if (material.equals(class_3614.field_15932) || material.equals(class_3614.field_22223)) {
                axes.add(block);
                continue;
            }
            if (material.equals(class_3614.field_15923) || material.equals(class_3614.field_15935) || material.equals(class_3614.field_15947)) {
                hoes.add(block);
                continue;
            }
            if (material.equals(class_3614.field_15916)) {
                shovels.add(block);
                continue;
            }
            other.add(block);
        }
        CommandRegistry.placeBlockRow(player, pos, pickaxes, 1, false);
        CommandRegistry.placeBlockRow(player, pos, axes, 2, false);
        CommandRegistry.placeBlockRow(player, pos, hoes, 3, false);
        CommandRegistry.placeBlockRow(player, pos, shovels, 4, false);
        CommandRegistry.placeBlockRow(player, pos, other, 5, false);
        return 1;
    }

    private static void placeBlockRow(class_3222 player, class_243 pos, List<class_2248> blocklist, int offset, boolean square) {
        int i = 0;
        int j = 0;
        int rowLen = (int)Math.ceil(Math.sqrt(blocklist.size()));
        blocklist.sort((a, b) -> {
            if (a instanceof class_2323 && !(b instanceof class_2323)) {
                return 1;
            }
            if (!(a instanceof class_2323) && b instanceof class_2323) {
                return -1;
            }
            return 0;
        });
        for (class_2248 bl : blocklist) {
            class_2680 state = bl.method_9564();
            class_2338 blockPos = new class_2338((int)pos.field_1352 + i, (int)pos.field_1351 + j, (int)pos.field_1350 + offset);
            CommandRegistry.place(player, bl, state, blockPos);
            if (++i < rowLen) continue;
            i = 0;
            ++j;
        }
    }

    private static void place(class_3222 player, class_2248 bl, class_2680 state, class_2338 blockPos) {
        if (bl instanceof class_2399) {
            // empty if block
        }
        BlocksHelper.setWithoutUpdate((class_1936)player.method_14220(), blockPos, state);
        if (bl instanceof class_2323) {
            BlocksHelper.setWithoutUpdate((class_1936)player.method_14220(), blockPos.method_10084(), (class_2680)state.method_11657((class_2769)class_2323.field_10946, (Comparable)class_2756.field_12609));
        }
    }
}

